package kz.gamma.cmp;

import kz.gamma.jce.provider.GammaTechProvider;
import kz.gamma.tumarcsp.LibraryWrapper;
import kz.gamma.tumarcsp.params.StoreObjectParam;

import java.security.KeyStore;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;

public class CmpEncryptSimpleTest {
    public static void main(String[] args) {
        try {
            Security.addProvider(new GammaTechProvider());

            String profile1 = "0_kisc_23.10.19";
            String profile2 = "0_kisc_10.04.20";

            //получение сертификатов из профайлов:
            X509Certificate[] certs = getCerts(new String[] {profile1,profile2});

            //данные для шифрования:
            byte[] data="hello".getBytes();

            CMPEncrypt cmpEncrypt = new CMPEncrypt();
            byte[] encrypted = cmpEncrypt.Encrypt(certs, data, true, LibraryWrapper.CALG_GOST);

            //расшифровывание с помощью профайла 1:
            byte[] decrypted1= cmpEncrypt.Decrypt(profile1, encrypted);

            //расшифровывание с помощью профайла 2:
            byte[] decrypted2 = cmpEncrypt.Decrypt(profile2, encrypted);

            //проверка соответствия начальным данным:
            if (!Arrays.equals(data, decrypted1) || !Arrays.equals(data, decrypted2)) {
                throw new Exception("test fail");
            } else {
                System.out.println("test success");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Получение сертификата из профайла
     * @param store
     * @param profile
     * @return
     * @throws Exception
     */
    private static X509Certificate getCert(KeyStore store, String profile) throws Exception {
        profile = "profile://" + profile;
        Enumeration en = store.aliases();
        while (en.hasMoreElements()) {
            StoreObjectParam prm = (StoreObjectParam) en.nextElement();
            if (prm.getProfile().equalsIgnoreCase(profile)) {
                X509Certificate certificate = prm.getX509certificate();
                return certificate;
            }
        }
        throw new RuntimeException("can't find keys in profile:" + profile);
    }

    /**
     * Получение сертификатов из профайлов
     * @param profiles
     * @return
     * @throws Exception
     */
    private static X509Certificate[] getCerts(String[] profiles) throws Exception{
        KeyStore store = KeyStore.getInstance("PKS", "GAMMA");
        store.load(null, null);
        X509Certificate[] certs = new X509Certificate[profiles.length];
        for(int i=0;i<profiles.length;i++){
            certs[i]= getCert(store, profiles[i]);
        }
        return certs;
    }
}
